package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.IspName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class IspPlacement(
    ispName: Optional[IspName] = Optional.Absent,
    placementStatistics: Optional[zio.aws.sesv2.model.PlacementStatistics] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.IspPlacement = {
    import IspPlacement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.IspPlacement
      .builder()
      .optionallyWith(
        ispName.map(value => IspName.unwrap(value): java.lang.String)
      )(_.ispName)
      .optionallyWith(placementStatistics.map(value => value.buildAwsValue()))(
        _.placementStatistics
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.IspPlacement.ReadOnly =
    zio.aws.sesv2.model.IspPlacement.wrap(buildAwsValue())
}
object IspPlacement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.IspPlacement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.IspPlacement =
      zio.aws.sesv2.model.IspPlacement(
        ispName.map(value => value),
        placementStatistics.map(value => value.asEditable)
      )
    def ispName: Optional[IspName]
    def placementStatistics
        : Optional[zio.aws.sesv2.model.PlacementStatistics.ReadOnly]
    def getIspName: ZIO[Any, AwsError, IspName] =
      AwsError.unwrapOptionField("ispName", ispName)
    def getPlacementStatistics
        : ZIO[Any, AwsError, zio.aws.sesv2.model.PlacementStatistics.ReadOnly] =
      AwsError.unwrapOptionField("placementStatistics", placementStatistics)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.IspPlacement
  ) extends zio.aws.sesv2.model.IspPlacement.ReadOnly {
    override val ispName: Optional[IspName] = zio.aws.core.internal
      .optionalFromNullable(impl.ispName())
      .map(value => zio.aws.sesv2.model.primitives.IspName(value))
    override val placementStatistics
        : Optional[zio.aws.sesv2.model.PlacementStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.placementStatistics())
        .map(value => zio.aws.sesv2.model.PlacementStatistics.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.IspPlacement
  ): zio.aws.sesv2.model.IspPlacement.ReadOnly = new Wrapper(impl)
}
