package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{NextToken, PoolName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListDedicatedIpPoolsResponse(
    dedicatedIpPools: Optional[Iterable[PoolName]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse = {
    import ListDedicatedIpPoolsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse
      .builder()
      .optionallyWith(
        dedicatedIpPools.map(value =>
          value.map { item =>
            PoolName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.dedicatedIpPools)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListDedicatedIpPoolsResponse.ReadOnly =
    zio.aws.sesv2.model.ListDedicatedIpPoolsResponse.wrap(buildAwsValue())
}
object ListDedicatedIpPoolsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListDedicatedIpPoolsResponse =
      zio.aws.sesv2.model.ListDedicatedIpPoolsResponse(
        dedicatedIpPools.map(value => value),
        nextToken.map(value => value)
      )
    def dedicatedIpPools: Optional[List[PoolName]]
    def nextToken: Optional[NextToken]
    def getDedicatedIpPools: ZIO[Any, AwsError, List[PoolName]] =
      AwsError.unwrapOptionField("dedicatedIpPools", dedicatedIpPools)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse
  ) extends zio.aws.sesv2.model.ListDedicatedIpPoolsResponse.ReadOnly {
    override val dedicatedIpPools: Optional[List[PoolName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedIpPools())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.primitives.PoolName(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListDedicatedIpPoolsResponse
  ): zio.aws.sesv2.model.ListDedicatedIpPoolsResponse.ReadOnly = new Wrapper(
    impl
  )
}
