package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListEmailIdentitiesResponse(
    emailIdentities: Optional[Iterable[zio.aws.sesv2.model.IdentityInfo]] =
      Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse = {
    import ListEmailIdentitiesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse
      .builder()
      .optionallyWith(
        emailIdentities.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.emailIdentities)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListEmailIdentitiesResponse.ReadOnly =
    zio.aws.sesv2.model.ListEmailIdentitiesResponse.wrap(buildAwsValue())
}
object ListEmailIdentitiesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListEmailIdentitiesResponse =
      zio.aws.sesv2.model.ListEmailIdentitiesResponse(
        emailIdentities.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def emailIdentities
        : Optional[List[zio.aws.sesv2.model.IdentityInfo.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getEmailIdentities
        : ZIO[Any, AwsError, List[zio.aws.sesv2.model.IdentityInfo.ReadOnly]] =
      AwsError.unwrapOptionField("emailIdentities", emailIdentities)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse
  ) extends zio.aws.sesv2.model.ListEmailIdentitiesResponse.ReadOnly {
    override val emailIdentities
        : Optional[List[zio.aws.sesv2.model.IdentityInfo.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.emailIdentities())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.IdentityInfo.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListEmailIdentitiesResponse
  ): zio.aws.sesv2.model.ListEmailIdentitiesResponse.ReadOnly = new Wrapper(
    impl
  )
}
