package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{TopicName, ContactListName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListManagementOptions(
    contactListName: ContactListName,
    topicName: Optional[TopicName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListManagementOptions = {
    import ListManagementOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListManagementOptions
      .builder()
      .contactListName(
        ContactListName.unwrap(contactListName): java.lang.String
      )
      .optionallyWith(
        topicName.map(value => TopicName.unwrap(value): java.lang.String)
      )(_.topicName)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListManagementOptions.ReadOnly =
    zio.aws.sesv2.model.ListManagementOptions.wrap(buildAwsValue())
}
object ListManagementOptions {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListManagementOptions
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListManagementOptions =
      zio.aws.sesv2.model
        .ListManagementOptions(contactListName, topicName.map(value => value))
    def contactListName: ContactListName
    def topicName: Optional[TopicName]
    def getContactListName: ZIO[Any, Nothing, ContactListName] =
      ZIO.succeed(contactListName)
    def getTopicName: ZIO[Any, AwsError, TopicName] =
      AwsError.unwrapOptionField("topicName", topicName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListManagementOptions
  ) extends zio.aws.sesv2.model.ListManagementOptions.ReadOnly {
    override val contactListName: ContactListName =
      zio.aws.sesv2.model.primitives.ContactListName(impl.contactListName())
    override val topicName: Optional[TopicName] = zio.aws.core.internal
      .optionalFromNullable(impl.topicName())
      .map(value => zio.aws.sesv2.model.primitives.TopicName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListManagementOptions
  ): zio.aws.sesv2.model.ListManagementOptions.ReadOnly = new Wrapper(impl)
}
