package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ListTagsForResourceResponse(
    tags: Iterable[zio.aws.sesv2.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListTagsForResourceResponse = {
    import ListTagsForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListTagsForResourceResponse
      .builder()
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListTagsForResourceResponse.ReadOnly =
    zio.aws.sesv2.model.ListTagsForResourceResponse.wrap(buildAwsValue())
}
object ListTagsForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListTagsForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListTagsForResourceResponse =
      zio.aws.sesv2.model.ListTagsForResourceResponse(tags.map { item =>
        item.asEditable
      })
    def tags: List[zio.aws.sesv2.model.Tag.ReadOnly]
    def getTags: ZIO[Any, Nothing, List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListTagsForResourceResponse
  ) extends zio.aws.sesv2.model.ListTagsForResourceResponse.ReadOnly {
    override val tags: List[zio.aws.sesv2.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.sesv2.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListTagsForResourceResponse
  ): zio.aws.sesv2.model.ListTagsForResourceResponse.ReadOnly = new Wrapper(
    impl
  )
}
