package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait MailFromDomainStatus {
  def unwrap: software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus
}
object MailFromDomainStatus {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus
  ): zio.aws.sesv2.model.MailFromDomainStatus = value match {
    case software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus.SUCCESS =>
      val r = SUCCESS
      r
    case software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus.TEMPORARY_FAILURE =>
      val r = TEMPORARY_FAILURE
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sesv2.model.MailFromDomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus =
      software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.sesv2.model.MailFromDomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus =
      software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus.PENDING
  }
  case object SUCCESS extends zio.aws.sesv2.model.MailFromDomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus =
      software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus.SUCCESS
  }
  case object FAILED extends zio.aws.sesv2.model.MailFromDomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus =
      software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus.FAILED
  }
  case object TEMPORARY_FAILURE
      extends zio.aws.sesv2.model.MailFromDomainStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus =
      software.amazon.awssdk.services.sesv2.model.MailFromDomainStatus.TEMPORARY_FAILURE
  }
}
