package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait Metric {
  def unwrap: software.amazon.awssdk.services.sesv2.model.Metric
}
object Metric {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.Metric
  ): zio.aws.sesv2.model.Metric = value match {
    case software.amazon.awssdk.services.sesv2.model.Metric.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.Metric.SEND =>
      val r = SEND
      r
    case software.amazon.awssdk.services.sesv2.model.Metric.COMPLAINT =>
      val r = COMPLAINT
      r
    case software.amazon.awssdk.services.sesv2.model.Metric.PERMANENT_BOUNCE =>
      val r = PERMANENT_BOUNCE
      r
    case software.amazon.awssdk.services.sesv2.model.Metric.TRANSIENT_BOUNCE =>
      val r = TRANSIENT_BOUNCE
      r
    case software.amazon.awssdk.services.sesv2.model.Metric.OPEN =>
      val r = OPEN
      r
    case software.amazon.awssdk.services.sesv2.model.Metric.CLICK =>
      val r = CLICK
      r
    case software.amazon.awssdk.services.sesv2.model.Metric.DELIVERY =>
      val r = DELIVERY
      r
    case software.amazon.awssdk.services.sesv2.model.Metric.DELIVERY_OPEN =>
      val r = DELIVERY_OPEN
      r
    case software.amazon.awssdk.services.sesv2.model.Metric.DELIVERY_CLICK =>
      val r = DELIVERY_CLICK
      r
    case software.amazon.awssdk.services.sesv2.model.Metric.DELIVERY_COMPLAINT =>
      val r = DELIVERY_COMPLAINT
      r
  }
  case object unknownToSdkVersion extends zio.aws.sesv2.model.Metric {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.Metric =
      software.amazon.awssdk.services.sesv2.model.Metric.UNKNOWN_TO_SDK_VERSION
  }
  case object SEND extends zio.aws.sesv2.model.Metric {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.Metric =
      software.amazon.awssdk.services.sesv2.model.Metric.SEND
  }
  case object COMPLAINT extends zio.aws.sesv2.model.Metric {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.Metric =
      software.amazon.awssdk.services.sesv2.model.Metric.COMPLAINT
  }
  case object PERMANENT_BOUNCE extends zio.aws.sesv2.model.Metric {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.Metric =
      software.amazon.awssdk.services.sesv2.model.Metric.PERMANENT_BOUNCE
  }
  case object TRANSIENT_BOUNCE extends zio.aws.sesv2.model.Metric {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.Metric =
      software.amazon.awssdk.services.sesv2.model.Metric.TRANSIENT_BOUNCE
  }
  case object OPEN extends zio.aws.sesv2.model.Metric {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.Metric =
      software.amazon.awssdk.services.sesv2.model.Metric.OPEN
  }
  case object CLICK extends zio.aws.sesv2.model.Metric {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.Metric =
      software.amazon.awssdk.services.sesv2.model.Metric.CLICK
  }
  case object DELIVERY extends zio.aws.sesv2.model.Metric {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.Metric =
      software.amazon.awssdk.services.sesv2.model.Metric.DELIVERY
  }
  case object DELIVERY_OPEN extends zio.aws.sesv2.model.Metric {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.Metric =
      software.amazon.awssdk.services.sesv2.model.Metric.DELIVERY_OPEN
  }
  case object DELIVERY_CLICK extends zio.aws.sesv2.model.Metric {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.Metric =
      software.amazon.awssdk.services.sesv2.model.Metric.DELIVERY_CLICK
  }
  case object DELIVERY_COMPLAINT extends zio.aws.sesv2.model.Metric {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.Metric =
      software.amazon.awssdk.services.sesv2.model.Metric.DELIVERY_COMPLAINT
  }
}
