package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  EnabledWrapper,
  AdditionalContactEmailAddress,
  UseCaseDescription,
  WebsiteURL
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutAccountDetailsRequest(
    mailType: zio.aws.sesv2.model.MailType,
    websiteURL: WebsiteURL,
    contactLanguage: Optional[zio.aws.sesv2.model.ContactLanguage] =
      Optional.Absent,
    useCaseDescription: UseCaseDescription,
    additionalContactEmailAddresses: Optional[
      Iterable[AdditionalContactEmailAddress]
    ] = Optional.Absent,
    productionAccessEnabled: Optional[EnabledWrapper] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutAccountDetailsRequest = {
    import PutAccountDetailsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutAccountDetailsRequest
      .builder()
      .mailType(mailType.unwrap)
      .websiteURL(WebsiteURL.unwrap(websiteURL): java.lang.String)
      .optionallyWith(contactLanguage.map(value => value.unwrap))(
        _.contactLanguage
      )
      .useCaseDescription(
        UseCaseDescription.unwrap(useCaseDescription): java.lang.String
      )
      .optionallyWith(
        additionalContactEmailAddresses.map(value =>
          value.map { item =>
            AdditionalContactEmailAddress.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.additionalContactEmailAddresses)
      .optionallyWith(
        productionAccessEnabled.map(value =>
          EnabledWrapper.unwrap(value): java.lang.Boolean
        )
      )(_.productionAccessEnabled)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.PutAccountDetailsRequest.ReadOnly =
    zio.aws.sesv2.model.PutAccountDetailsRequest.wrap(buildAwsValue())
}
object PutAccountDetailsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutAccountDetailsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.PutAccountDetailsRequest =
      zio.aws.sesv2.model.PutAccountDetailsRequest(
        mailType,
        websiteURL,
        contactLanguage.map(value => value),
        useCaseDescription,
        additionalContactEmailAddresses.map(value => value),
        productionAccessEnabled.map(value => value)
      )
    def mailType: zio.aws.sesv2.model.MailType
    def websiteURL: WebsiteURL
    def contactLanguage: Optional[zio.aws.sesv2.model.ContactLanguage]
    def useCaseDescription: UseCaseDescription
    def additionalContactEmailAddresses
        : Optional[List[AdditionalContactEmailAddress]]
    def productionAccessEnabled: Optional[EnabledWrapper]
    def getMailType: ZIO[Any, Nothing, zio.aws.sesv2.model.MailType] =
      ZIO.succeed(mailType)
    def getWebsiteURL: ZIO[Any, Nothing, WebsiteURL] = ZIO.succeed(websiteURL)
    def getContactLanguage
        : ZIO[Any, AwsError, zio.aws.sesv2.model.ContactLanguage] =
      AwsError.unwrapOptionField("contactLanguage", contactLanguage)
    def getUseCaseDescription: ZIO[Any, Nothing, UseCaseDescription] =
      ZIO.succeed(useCaseDescription)
    def getAdditionalContactEmailAddresses
        : ZIO[Any, AwsError, List[AdditionalContactEmailAddress]] =
      AwsError.unwrapOptionField(
        "additionalContactEmailAddresses",
        additionalContactEmailAddresses
      )
    def getProductionAccessEnabled: ZIO[Any, AwsError, EnabledWrapper] =
      AwsError.unwrapOptionField(
        "productionAccessEnabled",
        productionAccessEnabled
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutAccountDetailsRequest
  ) extends zio.aws.sesv2.model.PutAccountDetailsRequest.ReadOnly {
    override val mailType: zio.aws.sesv2.model.MailType =
      zio.aws.sesv2.model.MailType.wrap(impl.mailType())
    override val websiteURL: WebsiteURL =
      zio.aws.sesv2.model.primitives.WebsiteURL(impl.websiteURL())
    override val contactLanguage
        : Optional[zio.aws.sesv2.model.ContactLanguage] = zio.aws.core.internal
      .optionalFromNullable(impl.contactLanguage())
      .map(value => zio.aws.sesv2.model.ContactLanguage.wrap(value))
    override val useCaseDescription: UseCaseDescription =
      zio.aws.sesv2.model.primitives
        .UseCaseDescription(impl.useCaseDescription())
    override val additionalContactEmailAddresses
        : Optional[List[AdditionalContactEmailAddress]] = zio.aws.core.internal
      .optionalFromNullable(impl.additionalContactEmailAddresses())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.primitives.AdditionalContactEmailAddress(item)
        }.toList
      )
    override val productionAccessEnabled: Optional[EnabledWrapper] =
      zio.aws.core.internal
        .optionalFromNullable(impl.productionAccessEnabled())
        .map(value => zio.aws.sesv2.model.primitives.EnabledWrapper(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutAccountDetailsRequest
  ): zio.aws.sesv2.model.PutAccountDetailsRequest.ReadOnly = new Wrapper(impl)
}
