package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Enabled, ConfigurationSetName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutConfigurationSetSendingOptionsRequest(
    configurationSetName: ConfigurationSetName,
    sendingEnabled: Optional[Enabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsRequest = {
    import PutConfigurationSetSendingOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .optionallyWith(
        sendingEnabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.sendingEnabled)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutConfigurationSetSendingOptionsRequest.ReadOnly =
    zio.aws.sesv2.model.PutConfigurationSetSendingOptionsRequest
      .wrap(buildAwsValue())
}
object PutConfigurationSetSendingOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.PutConfigurationSetSendingOptionsRequest =
      zio.aws.sesv2.model.PutConfigurationSetSendingOptionsRequest(
        configurationSetName,
        sendingEnabled.map(value => value)
      )
    def configurationSetName: ConfigurationSetName
    def sendingEnabled: Optional[Enabled]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getSendingEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("sendingEnabled", sendingEnabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsRequest
  ) extends zio.aws.sesv2.model.PutConfigurationSetSendingOptionsRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.sesv2.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val sendingEnabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.sendingEnabled())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutConfigurationSetSendingOptionsRequest
  ): zio.aws.sesv2.model.PutConfigurationSetSendingOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
