package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.ConfigurationSetName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutConfigurationSetVdmOptionsRequest(
    configurationSetName: ConfigurationSetName,
    vdmOptions: Optional[zio.aws.sesv2.model.VdmOptions] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutConfigurationSetVdmOptionsRequest = {
    import PutConfigurationSetVdmOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutConfigurationSetVdmOptionsRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .optionallyWith(vdmOptions.map(value => value.buildAwsValue()))(
        _.vdmOptions
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutConfigurationSetVdmOptionsRequest.ReadOnly =
    zio.aws.sesv2.model.PutConfigurationSetVdmOptionsRequest
      .wrap(buildAwsValue())
}
object PutConfigurationSetVdmOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutConfigurationSetVdmOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.PutConfigurationSetVdmOptionsRequest =
      zio.aws.sesv2.model.PutConfigurationSetVdmOptionsRequest(
        configurationSetName,
        vdmOptions.map(value => value.asEditable)
      )
    def configurationSetName: ConfigurationSetName
    def vdmOptions: Optional[zio.aws.sesv2.model.VdmOptions.ReadOnly]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getVdmOptions
        : ZIO[Any, AwsError, zio.aws.sesv2.model.VdmOptions.ReadOnly] =
      AwsError.unwrapOptionField("vdmOptions", vdmOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutConfigurationSetVdmOptionsRequest
  ) extends zio.aws.sesv2.model.PutConfigurationSetVdmOptionsRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.sesv2.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val vdmOptions: Optional[zio.aws.sesv2.model.VdmOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.vdmOptions())
        .map(value => zio.aws.sesv2.model.VdmOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutConfigurationSetVdmOptionsRequest
  ): zio.aws.sesv2.model.PutConfigurationSetVdmOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
