package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait QueryErrorCode {
  def unwrap: software.amazon.awssdk.services.sesv2.model.QueryErrorCode
}
object QueryErrorCode {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.QueryErrorCode
  ): zio.aws.sesv2.model.QueryErrorCode = value match {
    case software.amazon.awssdk.services.sesv2.model.QueryErrorCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.QueryErrorCode.INTERNAL_FAILURE =>
      val r = INTERNAL_FAILURE
      r
    case software.amazon.awssdk.services.sesv2.model.QueryErrorCode.ACCESS_DENIED =>
      val r = ACCESS_DENIED
      r
  }
  case object unknownToSdkVersion extends zio.aws.sesv2.model.QueryErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.QueryErrorCode =
      software.amazon.awssdk.services.sesv2.model.QueryErrorCode.UNKNOWN_TO_SDK_VERSION
  }
  case object INTERNAL_FAILURE extends zio.aws.sesv2.model.QueryErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.QueryErrorCode =
      software.amazon.awssdk.services.sesv2.model.QueryErrorCode.INTERNAL_FAILURE
  }
  case object ACCESS_DENIED extends zio.aws.sesv2.model.QueryErrorCode {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.QueryErrorCode =
      software.amazon.awssdk.services.sesv2.model.QueryErrorCode.ACCESS_DENIED
  }
}
