package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.RawMessageData
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RawMessage(data: RawMessageData) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.RawMessage = {
    import RawMessage.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.RawMessage
      .builder()
      .data(
        software.amazon.awssdk.core.SdkBytes
          .fromByteArrayUnsafe(data.toArray[Byte])
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.RawMessage.ReadOnly =
    zio.aws.sesv2.model.RawMessage.wrap(buildAwsValue())
}
object RawMessage {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sesv2.model.RawMessage] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.RawMessage =
      zio.aws.sesv2.model.RawMessage(data)
    def data: RawMessageData
    def getData: ZIO[Any, Nothing, RawMessageData] = ZIO.succeed(data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.RawMessage
  ) extends zio.aws.sesv2.model.RawMessage.ReadOnly {
    override val data: RawMessageData = zio.aws.sesv2.model.primitives
      .RawMessageData(zio.Chunk.fromArray(impl.data().asByteArrayUnsafe()))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.RawMessage
  ): zio.aws.sesv2.model.RawMessage.ReadOnly = new Wrapper(impl)
}
