package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait RecommendationImpact {
  def unwrap: software.amazon.awssdk.services.sesv2.model.RecommendationImpact
}
object RecommendationImpact {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.RecommendationImpact
  ): zio.aws.sesv2.model.RecommendationImpact = value match {
    case software.amazon.awssdk.services.sesv2.model.RecommendationImpact.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.RecommendationImpact.LOW =>
      val r = LOW
      r
    case software.amazon.awssdk.services.sesv2.model.RecommendationImpact.HIGH =>
      val r = HIGH
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sesv2.model.RecommendationImpact {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.RecommendationImpact =
      software.amazon.awssdk.services.sesv2.model.RecommendationImpact.UNKNOWN_TO_SDK_VERSION
  }
  case object LOW extends zio.aws.sesv2.model.RecommendationImpact {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.RecommendationImpact =
      software.amazon.awssdk.services.sesv2.model.RecommendationImpact.LOW
  }
  case object HIGH extends zio.aws.sesv2.model.RecommendationImpact {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.RecommendationImpact =
      software.amazon.awssdk.services.sesv2.model.RecommendationImpact.HIGH
  }
}
