package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait RecommendationType {
  def unwrap: software.amazon.awssdk.services.sesv2.model.RecommendationType
}
object RecommendationType {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.RecommendationType
  ): zio.aws.sesv2.model.RecommendationType = value match {
    case software.amazon.awssdk.services.sesv2.model.RecommendationType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.RecommendationType.DKIM =>
      val r = DKIM
      r
    case software.amazon.awssdk.services.sesv2.model.RecommendationType.DMARC =>
      val r = DMARC
      r
    case software.amazon.awssdk.services.sesv2.model.RecommendationType.SPF =>
      val r = SPF
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sesv2.model.RecommendationType {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.RecommendationType =
      software.amazon.awssdk.services.sesv2.model.RecommendationType.UNKNOWN_TO_SDK_VERSION
  }
  case object DKIM extends zio.aws.sesv2.model.RecommendationType {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.RecommendationType =
      software.amazon.awssdk.services.sesv2.model.RecommendationType.DKIM
  }
  case object DMARC extends zio.aws.sesv2.model.RecommendationType {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.RecommendationType =
      software.amazon.awssdk.services.sesv2.model.RecommendationType.DMARC
  }
  case object SPF extends zio.aws.sesv2.model.RecommendationType {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.RecommendationType =
      software.amazon.awssdk.services.sesv2.model.RecommendationType.SPF
  }
}
