package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.CaseId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ReviewDetails(
    status: Optional[zio.aws.sesv2.model.ReviewStatus] = Optional.Absent,
    caseId: Optional[CaseId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ReviewDetails = {
    import ReviewDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ReviewDetails
      .builder()
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        caseId.map(value => CaseId.unwrap(value): java.lang.String)
      )(_.caseId)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ReviewDetails.ReadOnly =
    zio.aws.sesv2.model.ReviewDetails.wrap(buildAwsValue())
}
object ReviewDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ReviewDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ReviewDetails = zio.aws.sesv2.model
      .ReviewDetails(status.map(value => value), caseId.map(value => value))
    def status: Optional[zio.aws.sesv2.model.ReviewStatus]
    def caseId: Optional[CaseId]
    def getStatus: ZIO[Any, AwsError, zio.aws.sesv2.model.ReviewStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCaseId: ZIO[Any, AwsError, CaseId] =
      AwsError.unwrapOptionField("caseId", caseId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ReviewDetails
  ) extends zio.aws.sesv2.model.ReviewDetails.ReadOnly {
    override val status: Optional[zio.aws.sesv2.model.ReviewStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sesv2.model.ReviewStatus.wrap(value))
    override val caseId: Optional[CaseId] = zio.aws.core.internal
      .optionalFromNullable(impl.caseId())
      .map(value => zio.aws.sesv2.model.primitives.CaseId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ReviewDetails
  ): zio.aws.sesv2.model.ReviewDetails.ReadOnly = new Wrapper(impl)
}
