package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.OutboundMessageId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SendCustomVerificationEmailResponse(
    messageId: Optional[OutboundMessageId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailResponse = {
    import SendCustomVerificationEmailResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailResponse
      .builder()
      .optionallyWith(
        messageId.map(value =>
          OutboundMessageId.unwrap(value): java.lang.String
        )
      )(_.messageId)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.SendCustomVerificationEmailResponse.ReadOnly =
    zio.aws.sesv2.model.SendCustomVerificationEmailResponse
      .wrap(buildAwsValue())
}
object SendCustomVerificationEmailResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.SendCustomVerificationEmailResponse =
      zio.aws.sesv2.model
        .SendCustomVerificationEmailResponse(messageId.map(value => value))
    def messageId: Optional[OutboundMessageId]
    def getMessageId: ZIO[Any, AwsError, OutboundMessageId] =
      AwsError.unwrapOptionField("messageId", messageId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailResponse
  ) extends zio.aws.sesv2.model.SendCustomVerificationEmailResponse.ReadOnly {
    override val messageId: Optional[OutboundMessageId] = zio.aws.core.internal
      .optionalFromNullable(impl.messageId())
      .map(value => zio.aws.sesv2.model.primitives.OutboundMessageId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.SendCustomVerificationEmailResponse
  ): zio.aws.sesv2.model.SendCustomVerificationEmailResponse.ReadOnly =
    new Wrapper(impl)
}
