package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.RenderedEmailTemplate
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TestRenderEmailTemplateResponse(
    renderedTemplate: RenderedEmailTemplate
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateResponse = {
    import TestRenderEmailTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateResponse
      .builder()
      .renderedTemplate(
        RenderedEmailTemplate.unwrap(renderedTemplate): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.TestRenderEmailTemplateResponse.ReadOnly =
    zio.aws.sesv2.model.TestRenderEmailTemplateResponse.wrap(buildAwsValue())
}
object TestRenderEmailTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.TestRenderEmailTemplateResponse =
      zio.aws.sesv2.model.TestRenderEmailTemplateResponse(renderedTemplate)
    def renderedTemplate: RenderedEmailTemplate
    def getRenderedTemplate: ZIO[Any, Nothing, RenderedEmailTemplate] =
      ZIO.succeed(renderedTemplate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateResponse
  ) extends zio.aws.sesv2.model.TestRenderEmailTemplateResponse.ReadOnly {
    override val renderedTemplate: RenderedEmailTemplate =
      zio.aws.sesv2.model.primitives
        .RenderedEmailTemplate(impl.renderedTemplate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.TestRenderEmailTemplateResponse
  ): zio.aws.sesv2.model.TestRenderEmailTemplateResponse.ReadOnly = new Wrapper(
    impl
  )
}
