package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{Policy, PolicyName, Identity}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateEmailIdentityPolicyRequest(
    emailIdentity: Identity,
    policyName: PolicyName,
    policy: Policy
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.UpdateEmailIdentityPolicyRequest = {
    import UpdateEmailIdentityPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.UpdateEmailIdentityPolicyRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .policy(Policy.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.UpdateEmailIdentityPolicyRequest.ReadOnly =
    zio.aws.sesv2.model.UpdateEmailIdentityPolicyRequest.wrap(buildAwsValue())
}
object UpdateEmailIdentityPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.UpdateEmailIdentityPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.UpdateEmailIdentityPolicyRequest =
      zio.aws.sesv2.model
        .UpdateEmailIdentityPolicyRequest(emailIdentity, policyName, policy)
    def emailIdentity: Identity
    def policyName: PolicyName
    def policy: Policy
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getPolicy: ZIO[Any, Nothing, Policy] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.UpdateEmailIdentityPolicyRequest
  ) extends zio.aws.sesv2.model.UpdateEmailIdentityPolicyRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.sesv2.model.primitives.Identity(impl.emailIdentity())
    override val policyName: PolicyName =
      zio.aws.sesv2.model.primitives.PolicyName(impl.policyName())
    override val policy: Policy =
      zio.aws.sesv2.model.primitives.Policy(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.UpdateEmailIdentityPolicyRequest
  ): zio.aws.sesv2.model.UpdateEmailIdentityPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
