package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.EmailTemplateName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateEmailTemplateRequest(
    templateName: EmailTemplateName,
    templateContent: zio.aws.sesv2.model.EmailTemplateContent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.UpdateEmailTemplateRequest = {
    import UpdateEmailTemplateRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.UpdateEmailTemplateRequest
      .builder()
      .templateName(EmailTemplateName.unwrap(templateName): java.lang.String)
      .templateContent(templateContent.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.UpdateEmailTemplateRequest.ReadOnly =
    zio.aws.sesv2.model.UpdateEmailTemplateRequest.wrap(buildAwsValue())
}
object UpdateEmailTemplateRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.UpdateEmailTemplateRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.UpdateEmailTemplateRequest =
      zio.aws.sesv2.model
        .UpdateEmailTemplateRequest(templateName, templateContent.asEditable)
    def templateName: EmailTemplateName
    def templateContent: zio.aws.sesv2.model.EmailTemplateContent.ReadOnly
    def getTemplateName: ZIO[Any, Nothing, EmailTemplateName] =
      ZIO.succeed(templateName)
    def getTemplateContent
        : ZIO[Any, Nothing, zio.aws.sesv2.model.EmailTemplateContent.ReadOnly] =
      ZIO.succeed(templateContent)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.UpdateEmailTemplateRequest
  ) extends zio.aws.sesv2.model.UpdateEmailTemplateRequest.ReadOnly {
    override val templateName: EmailTemplateName =
      zio.aws.sesv2.model.primitives.EmailTemplateName(impl.templateName())
    override val templateContent
        : zio.aws.sesv2.model.EmailTemplateContent.ReadOnly =
      zio.aws.sesv2.model.EmailTemplateContent.wrap(impl.templateContent())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.UpdateEmailTemplateRequest
  ): zio.aws.sesv2.model.UpdateEmailTemplateRequest.ReadOnly = new Wrapper(impl)
}
