package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class VdmOptions(
    dashboardOptions: Optional[zio.aws.sesv2.model.DashboardOptions] =
      Optional.Absent,
    guardianOptions: Optional[zio.aws.sesv2.model.GuardianOptions] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.VdmOptions = {
    import VdmOptions.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.VdmOptions
      .builder()
      .optionallyWith(dashboardOptions.map(value => value.buildAwsValue()))(
        _.dashboardOptions
      )
      .optionallyWith(guardianOptions.map(value => value.buildAwsValue()))(
        _.guardianOptions
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.VdmOptions.ReadOnly =
    zio.aws.sesv2.model.VdmOptions.wrap(buildAwsValue())
}
object VdmOptions {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sesv2.model.VdmOptions] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.VdmOptions =
      zio.aws.sesv2.model.VdmOptions(
        dashboardOptions.map(value => value.asEditable),
        guardianOptions.map(value => value.asEditable)
      )
    def dashboardOptions
        : Optional[zio.aws.sesv2.model.DashboardOptions.ReadOnly]
    def guardianOptions: Optional[zio.aws.sesv2.model.GuardianOptions.ReadOnly]
    def getDashboardOptions
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DashboardOptions.ReadOnly] =
      AwsError.unwrapOptionField("dashboardOptions", dashboardOptions)
    def getGuardianOptions
        : ZIO[Any, AwsError, zio.aws.sesv2.model.GuardianOptions.ReadOnly] =
      AwsError.unwrapOptionField("guardianOptions", guardianOptions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.VdmOptions
  ) extends zio.aws.sesv2.model.VdmOptions.ReadOnly {
    override val dashboardOptions
        : Optional[zio.aws.sesv2.model.DashboardOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dashboardOptions())
        .map(value => zio.aws.sesv2.model.DashboardOptions.wrap(value))
    override val guardianOptions
        : Optional[zio.aws.sesv2.model.GuardianOptions.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.guardianOptions())
        .map(value => zio.aws.sesv2.model.GuardianOptions.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.VdmOptions
  ): zio.aws.sesv2.model.VdmOptions.ReadOnly = new Wrapper(impl)
}
