package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchGetMetricDataResponse(
    results: Optional[Iterable[zio.aws.sesv2.model.MetricDataResult]] =
      Optional.Absent,
    errors: Optional[Iterable[zio.aws.sesv2.model.MetricDataError]] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataResponse = {
    import BatchGetMetricDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataResponse
      .builder()
      .optionallyWith(
        results.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.results)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.BatchGetMetricDataResponse.ReadOnly =
    zio.aws.sesv2.model.BatchGetMetricDataResponse.wrap(buildAwsValue())
}
object BatchGetMetricDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.BatchGetMetricDataResponse =
      zio.aws.sesv2.model.BatchGetMetricDataResponse(
        results.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def results: Optional[List[zio.aws.sesv2.model.MetricDataResult.ReadOnly]]
    def errors: Optional[List[zio.aws.sesv2.model.MetricDataError.ReadOnly]]
    def getResults: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.MetricDataResult.ReadOnly
    ]] = AwsError.unwrapOptionField("results", results)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.MetricDataError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataResponse
  ) extends zio.aws.sesv2.model.BatchGetMetricDataResponse.ReadOnly {
    override val results
        : Optional[List[zio.aws.sesv2.model.MetricDataResult.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.results())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.MetricDataResult.wrap(item)
          }.toList
        )
    override val errors
        : Optional[List[zio.aws.sesv2.model.MetricDataError.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.errors())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.MetricDataError.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.BatchGetMetricDataResponse
  ): zio.aws.sesv2.model.BatchGetMetricDataResponse.ReadOnly = new Wrapper(impl)
}
