package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CloudWatchDestination(
    dimensionConfigurations: Iterable[
      zio.aws.sesv2.model.CloudWatchDimensionConfiguration
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.CloudWatchDestination = {
    import CloudWatchDestination.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.CloudWatchDestination
      .builder()
      .dimensionConfigurations(dimensionConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.CloudWatchDestination.ReadOnly =
    zio.aws.sesv2.model.CloudWatchDestination.wrap(buildAwsValue())
}
object CloudWatchDestination {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.CloudWatchDestination
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.CloudWatchDestination =
      zio.aws.sesv2.model.CloudWatchDestination(dimensionConfigurations.map {
        item =>
          item.asEditable
      })
    def dimensionConfigurations
        : List[zio.aws.sesv2.model.CloudWatchDimensionConfiguration.ReadOnly]
    def getDimensionConfigurations: ZIO[Any, Nothing, List[
      zio.aws.sesv2.model.CloudWatchDimensionConfiguration.ReadOnly
    ]] = ZIO.succeed(dimensionConfigurations)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.CloudWatchDestination
  ) extends zio.aws.sesv2.model.CloudWatchDestination.ReadOnly {
    override val dimensionConfigurations
        : List[zio.aws.sesv2.model.CloudWatchDimensionConfiguration.ReadOnly] =
      impl
        .dimensionConfigurations()
        .asScala
        .map { item =>
          zio.aws.sesv2.model.CloudWatchDimensionConfiguration.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.CloudWatchDestination
  ): zio.aws.sesv2.model.CloudWatchDestination.ReadOnly = new Wrapper(impl)
}
