package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{ConfigurationSetName, Identity}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateEmailIdentityRequest(
    emailIdentity: Identity,
    tags: Optional[Iterable[zio.aws.sesv2.model.Tag]] = Optional.Absent,
    dkimSigningAttributes: Optional[zio.aws.sesv2.model.DkimSigningAttributes] =
      Optional.Absent,
    configurationSetName: Optional[ConfigurationSetName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest = {
    import CreateEmailIdentityRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(
        dkimSigningAttributes.map(value => value.buildAwsValue())
      )(_.dkimSigningAttributes)
      .optionallyWith(
        configurationSetName.map(value =>
          ConfigurationSetName.unwrap(value): java.lang.String
        )
      )(_.configurationSetName)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.CreateEmailIdentityRequest.ReadOnly =
    zio.aws.sesv2.model.CreateEmailIdentityRequest.wrap(buildAwsValue())
}
object CreateEmailIdentityRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.CreateEmailIdentityRequest =
      zio.aws.sesv2.model.CreateEmailIdentityRequest(
        emailIdentity,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        dkimSigningAttributes.map(value => value.asEditable),
        configurationSetName.map(value => value)
      )
    def emailIdentity: Identity
    def tags: Optional[List[zio.aws.sesv2.model.Tag.ReadOnly]]
    def dkimSigningAttributes
        : Optional[zio.aws.sesv2.model.DkimSigningAttributes.ReadOnly]
    def configurationSetName: Optional[ConfigurationSetName]
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getDkimSigningAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.DkimSigningAttributes.ReadOnly
    ] =
      AwsError.unwrapOptionField("dkimSigningAttributes", dkimSigningAttributes)
    def getConfigurationSetName: ZIO[Any, AwsError, ConfigurationSetName] =
      AwsError.unwrapOptionField("configurationSetName", configurationSetName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest
  ) extends zio.aws.sesv2.model.CreateEmailIdentityRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.sesv2.model.primitives.Identity(impl.emailIdentity())
    override val tags: Optional[List[zio.aws.sesv2.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.Tag.wrap(item)
          }.toList
        )
    override val dkimSigningAttributes
        : Optional[zio.aws.sesv2.model.DkimSigningAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dkimSigningAttributes())
        .map(value => zio.aws.sesv2.model.DkimSigningAttributes.wrap(value))
    override val configurationSetName: Optional[ConfigurationSetName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.configurationSetName())
        .map(value =>
          zio.aws.sesv2.model.primitives.ConfigurationSetName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.CreateEmailIdentityRequest
  ): zio.aws.sesv2.model.CreateEmailIdentityRequest.ReadOnly = new Wrapper(impl)
}
