package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.Timestamp
import scala.jdk.CollectionConverters.*
final case class DailyVolume(
    startDate: Optional[Timestamp] = Optional.Absent,
    volumeStatistics: Optional[zio.aws.sesv2.model.VolumeStatistics] =
      Optional.Absent,
    domainIspPlacements: Optional[
      Iterable[zio.aws.sesv2.model.DomainIspPlacement]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DailyVolume = {
    import DailyVolume.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DailyVolume
      .builder()
      .optionallyWith(startDate.map(value => Timestamp.unwrap(value): Instant))(
        _.startDate
      )
      .optionallyWith(volumeStatistics.map(value => value.buildAwsValue()))(
        _.volumeStatistics
      )
      .optionallyWith(
        domainIspPlacements.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.domainIspPlacements)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DailyVolume.ReadOnly =
    zio.aws.sesv2.model.DailyVolume.wrap(buildAwsValue())
}
object DailyVolume {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sesv2.model.DailyVolume] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DailyVolume =
      zio.aws.sesv2.model.DailyVolume(
        startDate.map(value => value),
        volumeStatistics.map(value => value.asEditable),
        domainIspPlacements.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def startDate: Optional[Timestamp]
    def volumeStatistics
        : Optional[zio.aws.sesv2.model.VolumeStatistics.ReadOnly]
    def domainIspPlacements
        : Optional[List[zio.aws.sesv2.model.DomainIspPlacement.ReadOnly]]
    def getStartDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("startDate", startDate)
    def getVolumeStatistics
        : ZIO[Any, AwsError, zio.aws.sesv2.model.VolumeStatistics.ReadOnly] =
      AwsError.unwrapOptionField("volumeStatistics", volumeStatistics)
    def getDomainIspPlacements: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.DomainIspPlacement.ReadOnly
    ]] = AwsError.unwrapOptionField("domainIspPlacements", domainIspPlacements)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DailyVolume
  ) extends zio.aws.sesv2.model.DailyVolume.ReadOnly {
    override val startDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.startDate())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val volumeStatistics
        : Optional[zio.aws.sesv2.model.VolumeStatistics.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.volumeStatistics())
        .map(value => zio.aws.sesv2.model.VolumeStatistics.wrap(value))
    override val domainIspPlacements
        : Optional[List[zio.aws.sesv2.model.DomainIspPlacement.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.domainIspPlacements())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.DomainIspPlacement.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DailyVolume
  ): zio.aws.sesv2.model.DailyVolume.ReadOnly = new Wrapper(impl)
}
