package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.PoolName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DedicatedIpPool(
    poolName: PoolName,
    scalingMode: zio.aws.sesv2.model.ScalingMode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DedicatedIpPool = {
    import DedicatedIpPool.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DedicatedIpPool
      .builder()
      .poolName(PoolName.unwrap(poolName): java.lang.String)
      .scalingMode(scalingMode.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DedicatedIpPool.ReadOnly =
    zio.aws.sesv2.model.DedicatedIpPool.wrap(buildAwsValue())
}
object DedicatedIpPool {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DedicatedIpPool
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DedicatedIpPool =
      zio.aws.sesv2.model.DedicatedIpPool(poolName, scalingMode)
    def poolName: PoolName
    def scalingMode: zio.aws.sesv2.model.ScalingMode
    def getPoolName: ZIO[Any, Nothing, PoolName] = ZIO.succeed(poolName)
    def getScalingMode: ZIO[Any, Nothing, zio.aws.sesv2.model.ScalingMode] =
      ZIO.succeed(scalingMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DedicatedIpPool
  ) extends zio.aws.sesv2.model.DedicatedIpPool.ReadOnly {
    override val poolName: PoolName =
      zio.aws.sesv2.model.primitives.PoolName(impl.poolName())
    override val scalingMode: zio.aws.sesv2.model.ScalingMode =
      zio.aws.sesv2.model.ScalingMode.wrap(impl.scalingMode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DedicatedIpPool
  ): zio.aws.sesv2.model.DedicatedIpPool.ReadOnly = new Wrapper(impl)
}
