package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.PoolName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteDedicatedIpPoolRequest(poolName: PoolName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolRequest = {
    import DeleteDedicatedIpPoolRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolRequest
      .builder()
      .poolName(PoolName.unwrap(poolName): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DeleteDedicatedIpPoolRequest.ReadOnly =
    zio.aws.sesv2.model.DeleteDedicatedIpPoolRequest.wrap(buildAwsValue())
}
object DeleteDedicatedIpPoolRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DeleteDedicatedIpPoolRequest =
      zio.aws.sesv2.model.DeleteDedicatedIpPoolRequest(poolName)
    def poolName: PoolName
    def getPoolName: ZIO[Any, Nothing, PoolName] = ZIO.succeed(poolName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolRequest
  ) extends zio.aws.sesv2.model.DeleteDedicatedIpPoolRequest.ReadOnly {
    override val poolName: PoolName =
      zio.aws.sesv2.model.primitives.PoolName(impl.poolName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DeleteDedicatedIpPoolRequest
  ): zio.aws.sesv2.model.DeleteDedicatedIpPoolRequest.ReadOnly = new Wrapper(
    impl
  )
}
