package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{
  EmailAddress,
  ReportId,
  Timestamp,
  ReportName,
  DeliverabilityTestSubject
}
import scala.jdk.CollectionConverters.*
final case class DeliverabilityTestReport(
    reportId: Optional[ReportId] = Optional.Absent,
    reportName: Optional[ReportName] = Optional.Absent,
    subject: Optional[DeliverabilityTestSubject] = Optional.Absent,
    fromEmailAddress: Optional[EmailAddress] = Optional.Absent,
    createDate: Optional[Timestamp] = Optional.Absent,
    deliverabilityTestStatus: Optional[
      zio.aws.sesv2.model.DeliverabilityTestStatus
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.DeliverabilityTestReport = {
    import DeliverabilityTestReport.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.DeliverabilityTestReport
      .builder()
      .optionallyWith(
        reportId.map(value => ReportId.unwrap(value): java.lang.String)
      )(_.reportId)
      .optionallyWith(
        reportName.map(value => ReportName.unwrap(value): java.lang.String)
      )(_.reportName)
      .optionallyWith(
        subject.map(value =>
          DeliverabilityTestSubject.unwrap(value): java.lang.String
        )
      )(_.subject)
      .optionallyWith(
        fromEmailAddress.map(value =>
          EmailAddress.unwrap(value): java.lang.String
        )
      )(_.fromEmailAddress)
      .optionallyWith(
        createDate.map(value => Timestamp.unwrap(value): Instant)
      )(_.createDate)
      .optionallyWith(deliverabilityTestStatus.map(value => value.unwrap))(
        _.deliverabilityTestStatus
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.DeliverabilityTestReport.ReadOnly =
    zio.aws.sesv2.model.DeliverabilityTestReport.wrap(buildAwsValue())
}
object DeliverabilityTestReport {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.DeliverabilityTestReport
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.DeliverabilityTestReport =
      zio.aws.sesv2.model.DeliverabilityTestReport(
        reportId.map(value => value),
        reportName.map(value => value),
        subject.map(value => value),
        fromEmailAddress.map(value => value),
        createDate.map(value => value),
        deliverabilityTestStatus.map(value => value)
      )
    def reportId: Optional[ReportId]
    def reportName: Optional[ReportName]
    def subject: Optional[DeliverabilityTestSubject]
    def fromEmailAddress: Optional[EmailAddress]
    def createDate: Optional[Timestamp]
    def deliverabilityTestStatus
        : Optional[zio.aws.sesv2.model.DeliverabilityTestStatus]
    def getReportId: ZIO[Any, AwsError, ReportId] =
      AwsError.unwrapOptionField("reportId", reportId)
    def getReportName: ZIO[Any, AwsError, ReportName] =
      AwsError.unwrapOptionField("reportName", reportName)
    def getSubject: ZIO[Any, AwsError, DeliverabilityTestSubject] =
      AwsError.unwrapOptionField("subject", subject)
    def getFromEmailAddress: ZIO[Any, AwsError, EmailAddress] =
      AwsError.unwrapOptionField("fromEmailAddress", fromEmailAddress)
    def getCreateDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createDate", createDate)
    def getDeliverabilityTestStatus
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DeliverabilityTestStatus] =
      AwsError.unwrapOptionField(
        "deliverabilityTestStatus",
        deliverabilityTestStatus
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.DeliverabilityTestReport
  ) extends zio.aws.sesv2.model.DeliverabilityTestReport.ReadOnly {
    override val reportId: Optional[ReportId] = zio.aws.core.internal
      .optionalFromNullable(impl.reportId())
      .map(value => zio.aws.sesv2.model.primitives.ReportId(value))
    override val reportName: Optional[ReportName] = zio.aws.core.internal
      .optionalFromNullable(impl.reportName())
      .map(value => zio.aws.sesv2.model.primitives.ReportName(value))
    override val subject: Optional[DeliverabilityTestSubject] =
      zio.aws.core.internal
        .optionalFromNullable(impl.subject())
        .map(value =>
          zio.aws.sesv2.model.primitives.DeliverabilityTestSubject(value)
        )
    override val fromEmailAddress: Optional[EmailAddress] =
      zio.aws.core.internal
        .optionalFromNullable(impl.fromEmailAddress())
        .map(value => zio.aws.sesv2.model.primitives.EmailAddress(value))
    override val createDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createDate())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val deliverabilityTestStatus
        : Optional[zio.aws.sesv2.model.DeliverabilityTestStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deliverabilityTestStatus())
        .map(value => zio.aws.sesv2.model.DeliverabilityTestStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.DeliverabilityTestReport
  ): zio.aws.sesv2.model.DeliverabilityTestReport.ReadOnly = new Wrapper(impl)
}
