package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait DkimSigningAttributesOrigin {
  def unwrap
      : software.amazon.awssdk.services.sesv2.model.DkimSigningAttributesOrigin
}
object DkimSigningAttributesOrigin {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.DkimSigningAttributesOrigin
  ): zio.aws.sesv2.model.DkimSigningAttributesOrigin = value match {
    case software.amazon.awssdk.services.sesv2.model.DkimSigningAttributesOrigin.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.DkimSigningAttributesOrigin.AWS_SES =>
      val r = AWS_SES
      r
    case software.amazon.awssdk.services.sesv2.model.DkimSigningAttributesOrigin.EXTERNAL =>
      val r = EXTERNAL
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sesv2.model.DkimSigningAttributesOrigin {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.DkimSigningAttributesOrigin =
      software.amazon.awssdk.services.sesv2.model.DkimSigningAttributesOrigin.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS_SES extends zio.aws.sesv2.model.DkimSigningAttributesOrigin {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.DkimSigningAttributesOrigin =
      software.amazon.awssdk.services.sesv2.model.DkimSigningAttributesOrigin.AWS_SES
  }
  case object EXTERNAL extends zio.aws.sesv2.model.DkimSigningAttributesOrigin {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.DkimSigningAttributesOrigin =
      software.amazon.awssdk.services.sesv2.model.DkimSigningAttributesOrigin.EXTERNAL
  }
}
