package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{ErrorMessage, FailedRecordsS3Url}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FailureInfo(
    failedRecordsS3Url: Optional[FailedRecordsS3Url] = Optional.Absent,
    errorMessage: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.FailureInfo = {
    import FailureInfo.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.FailureInfo
      .builder()
      .optionallyWith(
        failedRecordsS3Url.map(value =>
          FailedRecordsS3Url.unwrap(value): java.lang.String
        )
      )(_.failedRecordsS3Url)
      .optionallyWith(
        errorMessage.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.errorMessage)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.FailureInfo.ReadOnly =
    zio.aws.sesv2.model.FailureInfo.wrap(buildAwsValue())
}
object FailureInfo {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sesv2.model.FailureInfo] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.FailureInfo =
      zio.aws.sesv2.model.FailureInfo(
        failedRecordsS3Url.map(value => value),
        errorMessage.map(value => value)
      )
    def failedRecordsS3Url: Optional[FailedRecordsS3Url]
    def errorMessage: Optional[ErrorMessage]
    def getFailedRecordsS3Url: ZIO[Any, AwsError, FailedRecordsS3Url] =
      AwsError.unwrapOptionField("failedRecordsS3Url", failedRecordsS3Url)
    def getErrorMessage: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("errorMessage", errorMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.FailureInfo
  ) extends zio.aws.sesv2.model.FailureInfo.ReadOnly {
    override val failedRecordsS3Url: Optional[FailedRecordsS3Url] =
      zio.aws.core.internal
        .optionalFromNullable(impl.failedRecordsS3Url())
        .map(value => zio.aws.sesv2.model.primitives.FailedRecordsS3Url(value))
    override val errorMessage: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.errorMessage())
      .map(value => zio.aws.sesv2.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.FailureInfo
  ): zio.aws.sesv2.model.FailureInfo.ReadOnly = new Wrapper(impl)
}
