package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait FeatureStatus {
  def unwrap: software.amazon.awssdk.services.sesv2.model.FeatureStatus
}
object FeatureStatus {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.FeatureStatus
  ): zio.aws.sesv2.model.FeatureStatus = value match {
    case software.amazon.awssdk.services.sesv2.model.FeatureStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.FeatureStatus.ENABLED =>
      val r = ENABLED
      r
    case software.amazon.awssdk.services.sesv2.model.FeatureStatus.DISABLED =>
      val r = DISABLED
      r
  }
  case object unknownToSdkVersion extends zio.aws.sesv2.model.FeatureStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.FeatureStatus =
      software.amazon.awssdk.services.sesv2.model.FeatureStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object ENABLED extends zio.aws.sesv2.model.FeatureStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.FeatureStatus =
      software.amazon.awssdk.services.sesv2.model.FeatureStatus.ENABLED
  }
  case object DISABLED extends zio.aws.sesv2.model.FeatureStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.FeatureStatus =
      software.amazon.awssdk.services.sesv2.model.FeatureStatus.DISABLED
  }
}
