package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.ContactListName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetContactListRequest(contactListName: ContactListName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetContactListRequest = {
    import GetContactListRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetContactListRequest
      .builder()
      .contactListName(
        ContactListName.unwrap(contactListName): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetContactListRequest.ReadOnly =
    zio.aws.sesv2.model.GetContactListRequest.wrap(buildAwsValue())
}
object GetContactListRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetContactListRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetContactListRequest =
      zio.aws.sesv2.model.GetContactListRequest(contactListName)
    def contactListName: ContactListName
    def getContactListName: ZIO[Any, Nothing, ContactListName] =
      ZIO.succeed(contactListName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetContactListRequest
  ) extends zio.aws.sesv2.model.GetContactListRequest.ReadOnly {
    override val contactListName: ContactListName =
      zio.aws.sesv2.model.primitives.ContactListName(impl.contactListName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetContactListRequest
  ): zio.aws.sesv2.model.GetContactListRequest.ReadOnly = new Wrapper(impl)
}
