package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetDedicatedIpPoolResponse(
    dedicatedIpPool: Optional[zio.aws.sesv2.model.DedicatedIpPool] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolResponse = {
    import GetDedicatedIpPoolResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolResponse
      .builder()
      .optionallyWith(dedicatedIpPool.map(value => value.buildAwsValue()))(
        _.dedicatedIpPool
      )
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetDedicatedIpPoolResponse.ReadOnly =
    zio.aws.sesv2.model.GetDedicatedIpPoolResponse.wrap(buildAwsValue())
}
object GetDedicatedIpPoolResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetDedicatedIpPoolResponse =
      zio.aws.sesv2.model.GetDedicatedIpPoolResponse(
        dedicatedIpPool.map(value => value.asEditable)
      )
    def dedicatedIpPool: Optional[zio.aws.sesv2.model.DedicatedIpPool.ReadOnly]
    def getDedicatedIpPool
        : ZIO[Any, AwsError, zio.aws.sesv2.model.DedicatedIpPool.ReadOnly] =
      AwsError.unwrapOptionField("dedicatedIpPool", dedicatedIpPool)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolResponse
  ) extends zio.aws.sesv2.model.GetDedicatedIpPoolResponse.ReadOnly {
    override val dedicatedIpPool
        : Optional[zio.aws.sesv2.model.DedicatedIpPool.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.dedicatedIpPool())
        .map(value => zio.aws.sesv2.model.DedicatedIpPool.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetDedicatedIpPoolResponse
  ): zio.aws.sesv2.model.GetDedicatedIpPoolResponse.ReadOnly = new Wrapper(impl)
}
