package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.CampaignId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetDomainDeliverabilityCampaignRequest(
    campaignId: CampaignId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignRequest = {
    import GetDomainDeliverabilityCampaignRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignRequest
      .builder()
      .campaignId(CampaignId.unwrap(campaignId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.GetDomainDeliverabilityCampaignRequest.ReadOnly =
    zio.aws.sesv2.model.GetDomainDeliverabilityCampaignRequest
      .wrap(buildAwsValue())
}
object GetDomainDeliverabilityCampaignRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetDomainDeliverabilityCampaignRequest =
      zio.aws.sesv2.model.GetDomainDeliverabilityCampaignRequest(campaignId)
    def campaignId: CampaignId
    def getCampaignId: ZIO[Any, Nothing, CampaignId] = ZIO.succeed(campaignId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignRequest
  ) extends zio.aws.sesv2.model.GetDomainDeliverabilityCampaignRequest.ReadOnly {
    override val campaignId: CampaignId =
      zio.aws.sesv2.model.primitives.CampaignId(impl.campaignId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetDomainDeliverabilityCampaignRequest
  ): zio.aws.sesv2.model.GetDomainDeliverabilityCampaignRequest.ReadOnly =
    new Wrapper(impl)
}
