package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.JobId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetImportJobRequest(jobId: JobId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.GetImportJobRequest = {
    import GetImportJobRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.GetImportJobRequest
      .builder()
      .jobId(JobId.unwrap(jobId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.GetImportJobRequest.ReadOnly =
    zio.aws.sesv2.model.GetImportJobRequest.wrap(buildAwsValue())
}
object GetImportJobRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.GetImportJobRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.GetImportJobRequest =
      zio.aws.sesv2.model.GetImportJobRequest(jobId)
    def jobId: JobId
    def getJobId: ZIO[Any, Nothing, JobId] = ZIO.succeed(jobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.GetImportJobRequest
  ) extends zio.aws.sesv2.model.GetImportJobRequest.ReadOnly {
    override val jobId: JobId =
      zio.aws.sesv2.model.primitives.JobId(impl.jobId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.GetImportJobRequest
  ): zio.aws.sesv2.model.GetImportJobRequest.ReadOnly = new Wrapper(impl)
}
