package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{IspName, Enabled}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class InboxPlacementTrackingOption(
    global: Optional[Enabled] = Optional.Absent,
    trackedIsps: Optional[Iterable[IspName]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.InboxPlacementTrackingOption = {
    import InboxPlacementTrackingOption.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.InboxPlacementTrackingOption
      .builder()
      .optionallyWith(
        global.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.global)
      .optionallyWith(
        trackedIsps.map(value =>
          value.map { item =>
            IspName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.trackedIsps)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.InboxPlacementTrackingOption.ReadOnly =
    zio.aws.sesv2.model.InboxPlacementTrackingOption.wrap(buildAwsValue())
}
object InboxPlacementTrackingOption {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.InboxPlacementTrackingOption
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.InboxPlacementTrackingOption =
      zio.aws.sesv2.model.InboxPlacementTrackingOption(
        global.map(value => value),
        trackedIsps.map(value => value)
      )
    def global: Optional[Enabled]
    def trackedIsps: Optional[List[IspName]]
    def getGlobal: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("global", global)
    def getTrackedIsps: ZIO[Any, AwsError, List[IspName]] =
      AwsError.unwrapOptionField("trackedIsps", trackedIsps)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.InboxPlacementTrackingOption
  ) extends zio.aws.sesv2.model.InboxPlacementTrackingOption.ReadOnly {
    override val global: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.global())
      .map(value => zio.aws.sesv2.model.primitives.Enabled(value))
    override val trackedIsps: Optional[List[IspName]] = zio.aws.core.internal
      .optionalFromNullable(impl.trackedIsps())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sesv2.model.primitives.IspName(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.InboxPlacementTrackingOption
  ): zio.aws.sesv2.model.InboxPlacementTrackingOption.ReadOnly = new Wrapper(
    impl
  )
}
