package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait JobStatus {
  def unwrap: software.amazon.awssdk.services.sesv2.model.JobStatus
}
object JobStatus {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.JobStatus
  ): zio.aws.sesv2.model.JobStatus = value match {
    case software.amazon.awssdk.services.sesv2.model.JobStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.JobStatus.CREATED =>
      val r = CREATED
      r
    case software.amazon.awssdk.services.sesv2.model.JobStatus.PROCESSING =>
      val r = PROCESSING
      r
    case software.amazon.awssdk.services.sesv2.model.JobStatus.COMPLETED =>
      val r = COMPLETED
      r
    case software.amazon.awssdk.services.sesv2.model.JobStatus.FAILED =>
      val r = FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.sesv2.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.JobStatus =
      software.amazon.awssdk.services.sesv2.model.JobStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATED extends zio.aws.sesv2.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.JobStatus =
      software.amazon.awssdk.services.sesv2.model.JobStatus.CREATED
  }
  case object PROCESSING extends zio.aws.sesv2.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.JobStatus =
      software.amazon.awssdk.services.sesv2.model.JobStatus.PROCESSING
  }
  case object COMPLETED extends zio.aws.sesv2.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.JobStatus =
      software.amazon.awssdk.services.sesv2.model.JobStatus.COMPLETED
  }
  case object FAILED extends zio.aws.sesv2.model.JobStatus {
    override def unwrap: software.amazon.awssdk.services.sesv2.model.JobStatus =
      software.amazon.awssdk.services.sesv2.model.JobStatus.FAILED
  }
}
