package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListEmailTemplatesResponse(
    templatesMetadata: Optional[
      Iterable[zio.aws.sesv2.model.EmailTemplateMetadata]
    ] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse = {
    import ListEmailTemplatesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse
      .builder()
      .optionallyWith(
        templatesMetadata.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.templatesMetadata)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.ListEmailTemplatesResponse.ReadOnly =
    zio.aws.sesv2.model.ListEmailTemplatesResponse.wrap(buildAwsValue())
}
object ListEmailTemplatesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.ListEmailTemplatesResponse =
      zio.aws.sesv2.model.ListEmailTemplatesResponse(
        templatesMetadata.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def templatesMetadata
        : Optional[List[zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getTemplatesMetadata: ZIO[Any, AwsError, List[
      zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly
    ]] = AwsError.unwrapOptionField("templatesMetadata", templatesMetadata)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse
  ) extends zio.aws.sesv2.model.ListEmailTemplatesResponse.ReadOnly {
    override val templatesMetadata
        : Optional[List[zio.aws.sesv2.model.EmailTemplateMetadata.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.templatesMetadata())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sesv2.model.EmailTemplateMetadata.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sesv2.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.ListEmailTemplatesResponse
  ): zio.aws.sesv2.model.ListEmailTemplatesResponse.ReadOnly = new Wrapper(impl)
}
