package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.MailFromDomainName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MailFromAttributes(
    mailFromDomain: MailFromDomainName,
    mailFromDomainStatus: zio.aws.sesv2.model.MailFromDomainStatus,
    behaviorOnMxFailure: zio.aws.sesv2.model.BehaviorOnMxFailure
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.MailFromAttributes = {
    import MailFromAttributes.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.MailFromAttributes
      .builder()
      .mailFromDomain(
        MailFromDomainName.unwrap(mailFromDomain): java.lang.String
      )
      .mailFromDomainStatus(mailFromDomainStatus.unwrap)
      .behaviorOnMxFailure(behaviorOnMxFailure.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.MailFromAttributes.ReadOnly =
    zio.aws.sesv2.model.MailFromAttributes.wrap(buildAwsValue())
}
object MailFromAttributes {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.MailFromAttributes
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.MailFromAttributes =
      zio.aws.sesv2.model.MailFromAttributes(
        mailFromDomain,
        mailFromDomainStatus,
        behaviorOnMxFailure
      )
    def mailFromDomain: MailFromDomainName
    def mailFromDomainStatus: zio.aws.sesv2.model.MailFromDomainStatus
    def behaviorOnMxFailure: zio.aws.sesv2.model.BehaviorOnMxFailure
    def getMailFromDomain: ZIO[Any, Nothing, MailFromDomainName] =
      ZIO.succeed(mailFromDomain)
    def getMailFromDomainStatus
        : ZIO[Any, Nothing, zio.aws.sesv2.model.MailFromDomainStatus] =
      ZIO.succeed(mailFromDomainStatus)
    def getBehaviorOnMxFailure
        : ZIO[Any, Nothing, zio.aws.sesv2.model.BehaviorOnMxFailure] =
      ZIO.succeed(behaviorOnMxFailure)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.MailFromAttributes
  ) extends zio.aws.sesv2.model.MailFromAttributes.ReadOnly {
    override val mailFromDomain: MailFromDomainName =
      zio.aws.sesv2.model.primitives.MailFromDomainName(impl.mailFromDomain())
    override val mailFromDomainStatus
        : zio.aws.sesv2.model.MailFromDomainStatus =
      zio.aws.sesv2.model.MailFromDomainStatus.wrap(impl.mailFromDomainStatus())
    override val behaviorOnMxFailure: zio.aws.sesv2.model.BehaviorOnMxFailure =
      zio.aws.sesv2.model.BehaviorOnMxFailure.wrap(impl.behaviorOnMxFailure())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.MailFromAttributes
  ): zio.aws.sesv2.model.MailFromAttributes.ReadOnly = new Wrapper(impl)
}
