package zio.aws.sesv2.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class Message(
    subject: zio.aws.sesv2.model.Content,
    body: zio.aws.sesv2.model.Body
) {
  def buildAwsValue(): software.amazon.awssdk.services.sesv2.model.Message = {
    import Message.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.Message
      .builder()
      .subject(subject.buildAwsValue())
      .body(body.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.Message.ReadOnly =
    zio.aws.sesv2.model.Message.wrap(buildAwsValue())
}
object Message {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sesv2.model.Message] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.Message =
      zio.aws.sesv2.model.Message(subject.asEditable, body.asEditable)
    def subject: zio.aws.sesv2.model.Content.ReadOnly
    def body: zio.aws.sesv2.model.Body.ReadOnly
    def getSubject: ZIO[Any, Nothing, zio.aws.sesv2.model.Content.ReadOnly] =
      ZIO.succeed(subject)
    def getBody: ZIO[Any, Nothing, zio.aws.sesv2.model.Body.ReadOnly] =
      ZIO.succeed(body)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.Message
  ) extends zio.aws.sesv2.model.Message.ReadOnly {
    override val subject: zio.aws.sesv2.model.Content.ReadOnly =
      zio.aws.sesv2.model.Content.wrap(impl.subject())
    override val body: zio.aws.sesv2.model.Body.ReadOnly =
      zio.aws.sesv2.model.Body.wrap(impl.body())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.Message
  ): zio.aws.sesv2.model.Message.ReadOnly = new Wrapper(impl)
}
