package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{MessageTagValue, MessageTagName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class MessageTag(name: MessageTagName, value: MessageTagValue) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.MessageTag = {
    import MessageTag.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.MessageTag
      .builder()
      .name(MessageTagName.unwrap(name): java.lang.String)
      .value(MessageTagValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.MessageTag.ReadOnly =
    zio.aws.sesv2.model.MessageTag.wrap(buildAwsValue())
}
object MessageTag {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sesv2.model.MessageTag] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.MessageTag =
      zio.aws.sesv2.model.MessageTag(name, value)
    def name: MessageTagName
    def value: MessageTagValue
    def getName: ZIO[Any, Nothing, MessageTagName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, MessageTagValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.MessageTag
  ) extends zio.aws.sesv2.model.MessageTag.ReadOnly {
    override val name: MessageTagName =
      zio.aws.sesv2.model.primitives.MessageTagName(impl.name())
    override val value: MessageTagValue =
      zio.aws.sesv2.model.primitives.MessageTagValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.MessageTag
  ): zio.aws.sesv2.model.MessageTag.ReadOnly = new Wrapper(impl)
}
