package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait MetricDimensionName {
  def unwrap: software.amazon.awssdk.services.sesv2.model.MetricDimensionName
}
object MetricDimensionName {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.MetricDimensionName
  ): zio.aws.sesv2.model.MetricDimensionName = value match {
    case software.amazon.awssdk.services.sesv2.model.MetricDimensionName.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.MetricDimensionName.EMAIL_IDENTITY =>
      val r = EMAIL_IDENTITY
      r
    case software.amazon.awssdk.services.sesv2.model.MetricDimensionName.CONFIGURATION_SET =>
      val r = CONFIGURATION_SET
      r
    case software.amazon.awssdk.services.sesv2.model.MetricDimensionName.ISP =>
      val r = ISP
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sesv2.model.MetricDimensionName {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.MetricDimensionName =
      software.amazon.awssdk.services.sesv2.model.MetricDimensionName.UNKNOWN_TO_SDK_VERSION
  }
  case object EMAIL_IDENTITY extends zio.aws.sesv2.model.MetricDimensionName {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.MetricDimensionName =
      software.amazon.awssdk.services.sesv2.model.MetricDimensionName.EMAIL_IDENTITY
  }
  case object CONFIGURATION_SET
      extends zio.aws.sesv2.model.MetricDimensionName {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.MetricDimensionName =
      software.amazon.awssdk.services.sesv2.model.MetricDimensionName.CONFIGURATION_SET
  }
  case object ISP extends zio.aws.sesv2.model.MetricDimensionName {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.MetricDimensionName =
      software.amazon.awssdk.services.sesv2.model.MetricDimensionName.ISP
  }
}
