package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait MetricNamespace {
  def unwrap: software.amazon.awssdk.services.sesv2.model.MetricNamespace
}
object MetricNamespace {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.MetricNamespace
  ): zio.aws.sesv2.model.MetricNamespace = value match {
    case software.amazon.awssdk.services.sesv2.model.MetricNamespace.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.MetricNamespace.VDM =>
      val r = VDM
      r
  }
  case object unknownToSdkVersion extends zio.aws.sesv2.model.MetricNamespace {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.MetricNamespace =
      software.amazon.awssdk.services.sesv2.model.MetricNamespace.UNKNOWN_TO_SDK_VERSION
  }
  case object VDM extends zio.aws.sesv2.model.MetricNamespace {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.MetricNamespace =
      software.amazon.awssdk.services.sesv2.model.MetricNamespace.VDM
  }
}
