package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.Percentage
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PlacementStatistics(
    inboxPercentage: Optional[Percentage] = Optional.Absent,
    spamPercentage: Optional[Percentage] = Optional.Absent,
    missingPercentage: Optional[Percentage] = Optional.Absent,
    spfPercentage: Optional[Percentage] = Optional.Absent,
    dkimPercentage: Optional[Percentage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PlacementStatistics = {
    import PlacementStatistics.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PlacementStatistics
      .builder()
      .optionallyWith(
        inboxPercentage.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.inboxPercentage)
      .optionallyWith(
        spamPercentage.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.spamPercentage)
      .optionallyWith(
        missingPercentage.map(value =>
          Percentage.unwrap(value): java.lang.Double
        )
      )(_.missingPercentage)
      .optionallyWith(
        spfPercentage.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.spfPercentage)
      .optionallyWith(
        dkimPercentage.map(value => Percentage.unwrap(value): java.lang.Double)
      )(_.dkimPercentage)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.PlacementStatistics.ReadOnly =
    zio.aws.sesv2.model.PlacementStatistics.wrap(buildAwsValue())
}
object PlacementStatistics {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PlacementStatistics
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.PlacementStatistics =
      zio.aws.sesv2.model.PlacementStatistics(
        inboxPercentage.map(value => value),
        spamPercentage.map(value => value),
        missingPercentage.map(value => value),
        spfPercentage.map(value => value),
        dkimPercentage.map(value => value)
      )
    def inboxPercentage: Optional[Percentage]
    def spamPercentage: Optional[Percentage]
    def missingPercentage: Optional[Percentage]
    def spfPercentage: Optional[Percentage]
    def dkimPercentage: Optional[Percentage]
    def getInboxPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("inboxPercentage", inboxPercentage)
    def getSpamPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("spamPercentage", spamPercentage)
    def getMissingPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("missingPercentage", missingPercentage)
    def getSpfPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("spfPercentage", spfPercentage)
    def getDkimPercentage: ZIO[Any, AwsError, Percentage] =
      AwsError.unwrapOptionField("dkimPercentage", dkimPercentage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PlacementStatistics
  ) extends zio.aws.sesv2.model.PlacementStatistics.ReadOnly {
    override val inboxPercentage: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.inboxPercentage())
      .map(value => zio.aws.sesv2.model.primitives.Percentage(value))
    override val spamPercentage: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.spamPercentage())
      .map(value => zio.aws.sesv2.model.primitives.Percentage(value))
    override val missingPercentage: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.missingPercentage())
      .map(value => zio.aws.sesv2.model.primitives.Percentage(value))
    override val spfPercentage: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.spfPercentage())
      .map(value => zio.aws.sesv2.model.primitives.Percentage(value))
    override val dkimPercentage: Optional[Percentage] = zio.aws.core.internal
      .optionalFromNullable(impl.dkimPercentage())
      .map(value => zio.aws.sesv2.model.primitives.Percentage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PlacementStatistics
  ): zio.aws.sesv2.model.PlacementStatistics.ReadOnly = new Wrapper(impl)
}
