package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.{
  CustomRedirectDomain,
  ConfigurationSetName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutConfigurationSetTrackingOptionsRequest(
    configurationSetName: ConfigurationSetName,
    customRedirectDomain: Optional[CustomRedirectDomain] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsRequest = {
    import PutConfigurationSetTrackingOptionsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsRequest
      .builder()
      .configurationSetName(
        ConfigurationSetName.unwrap(configurationSetName): java.lang.String
      )
      .optionallyWith(
        customRedirectDomain.map(value =>
          CustomRedirectDomain.unwrap(value): java.lang.String
        )
      )(_.customRedirectDomain)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutConfigurationSetTrackingOptionsRequest.ReadOnly =
    zio.aws.sesv2.model.PutConfigurationSetTrackingOptionsRequest
      .wrap(buildAwsValue())
}
object PutConfigurationSetTrackingOptionsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.PutConfigurationSetTrackingOptionsRequest =
      zio.aws.sesv2.model.PutConfigurationSetTrackingOptionsRequest(
        configurationSetName,
        customRedirectDomain.map(value => value)
      )
    def configurationSetName: ConfigurationSetName
    def customRedirectDomain: Optional[CustomRedirectDomain]
    def getConfigurationSetName: ZIO[Any, Nothing, ConfigurationSetName] =
      ZIO.succeed(configurationSetName)
    def getCustomRedirectDomain: ZIO[Any, AwsError, CustomRedirectDomain] =
      AwsError.unwrapOptionField("customRedirectDomain", customRedirectDomain)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsRequest
  ) extends zio.aws.sesv2.model.PutConfigurationSetTrackingOptionsRequest.ReadOnly {
    override val configurationSetName: ConfigurationSetName =
      zio.aws.sesv2.model.primitives
        .ConfigurationSetName(impl.configurationSetName())
    override val customRedirectDomain: Optional[CustomRedirectDomain] =
      zio.aws.core.internal
        .optionalFromNullable(impl.customRedirectDomain())
        .map(value =>
          zio.aws.sesv2.model.primitives.CustomRedirectDomain(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutConfigurationSetTrackingOptionsRequest
  ): zio.aws.sesv2.model.PutConfigurationSetTrackingOptionsRequest.ReadOnly =
    new Wrapper(impl)
}
