package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.PoolName
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutDedicatedIpPoolScalingAttributesRequest(
    poolName: PoolName,
    scalingMode: zio.aws.sesv2.model.ScalingMode
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutDedicatedIpPoolScalingAttributesRequest = {
    import PutDedicatedIpPoolScalingAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutDedicatedIpPoolScalingAttributesRequest
      .builder()
      .poolName(PoolName.unwrap(poolName): java.lang.String)
      .scalingMode(scalingMode.unwrap)
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutDedicatedIpPoolScalingAttributesRequest.ReadOnly =
    zio.aws.sesv2.model.PutDedicatedIpPoolScalingAttributesRequest
      .wrap(buildAwsValue())
}
object PutDedicatedIpPoolScalingAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutDedicatedIpPoolScalingAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.PutDedicatedIpPoolScalingAttributesRequest =
      zio.aws.sesv2.model
        .PutDedicatedIpPoolScalingAttributesRequest(poolName, scalingMode)
    def poolName: PoolName
    def scalingMode: zio.aws.sesv2.model.ScalingMode
    def getPoolName: ZIO[Any, Nothing, PoolName] = ZIO.succeed(poolName)
    def getScalingMode: ZIO[Any, Nothing, zio.aws.sesv2.model.ScalingMode] =
      ZIO.succeed(scalingMode)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutDedicatedIpPoolScalingAttributesRequest
  ) extends zio.aws.sesv2.model.PutDedicatedIpPoolScalingAttributesRequest.ReadOnly {
    override val poolName: PoolName =
      zio.aws.sesv2.model.primitives.PoolName(impl.poolName())
    override val scalingMode: zio.aws.sesv2.model.ScalingMode =
      zio.aws.sesv2.model.ScalingMode.wrap(impl.scalingMode())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutDedicatedIpPoolScalingAttributesRequest
  ): zio.aws.sesv2.model.PutDedicatedIpPoolScalingAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
