package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.Identity
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class PutEmailIdentityDkimSigningAttributesRequest(
    emailIdentity: Identity,
    signingAttributesOrigin: zio.aws.sesv2.model.DkimSigningAttributesOrigin,
    signingAttributes: Optional[zio.aws.sesv2.model.DkimSigningAttributes] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest = {
    import PutEmailIdentityDkimSigningAttributesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest
      .builder()
      .emailIdentity(Identity.unwrap(emailIdentity): java.lang.String)
      .signingAttributesOrigin(signingAttributesOrigin.unwrap)
      .optionallyWith(signingAttributes.map(value => value.buildAwsValue()))(
        _.signingAttributes
      )
      .build()
  }
  def asReadOnly
      : zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest.ReadOnly =
    zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest
      .wrap(buildAwsValue())
}
object PutEmailIdentityDkimSigningAttributesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest =
      zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest(
        emailIdentity,
        signingAttributesOrigin,
        signingAttributes.map(value => value.asEditable)
      )
    def emailIdentity: Identity
    def signingAttributesOrigin: zio.aws.sesv2.model.DkimSigningAttributesOrigin
    def signingAttributes
        : Optional[zio.aws.sesv2.model.DkimSigningAttributes.ReadOnly]
    def getEmailIdentity: ZIO[Any, Nothing, Identity] =
      ZIO.succeed(emailIdentity)
    def getSigningAttributesOrigin
        : ZIO[Any, Nothing, zio.aws.sesv2.model.DkimSigningAttributesOrigin] =
      ZIO.succeed(signingAttributesOrigin)
    def getSigningAttributes: ZIO[
      Any,
      AwsError,
      zio.aws.sesv2.model.DkimSigningAttributes.ReadOnly
    ] = AwsError.unwrapOptionField("signingAttributes", signingAttributes)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest
  ) extends zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest.ReadOnly {
    override val emailIdentity: Identity =
      zio.aws.sesv2.model.primitives.Identity(impl.emailIdentity())
    override val signingAttributesOrigin
        : zio.aws.sesv2.model.DkimSigningAttributesOrigin =
      zio.aws.sesv2.model.DkimSigningAttributesOrigin
        .wrap(impl.signingAttributesOrigin())
    override val signingAttributes
        : Optional[zio.aws.sesv2.model.DkimSigningAttributes.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.signingAttributes())
        .map(value => zio.aws.sesv2.model.DkimSigningAttributes.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest
  ): zio.aws.sesv2.model.PutEmailIdentityDkimSigningAttributesRequest.ReadOnly =
    new Wrapper(impl)
}
