package zio.aws.sesv2.model
import zio.aws.sesv2.model.primitives.EmailAddress
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutSuppressedDestinationRequest(
    emailAddress: EmailAddress,
    reason: zio.aws.sesv2.model.SuppressionListReason
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationRequest = {
    import PutSuppressedDestinationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationRequest
      .builder()
      .emailAddress(EmailAddress.unwrap(emailAddress): java.lang.String)
      .reason(reason.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.PutSuppressedDestinationRequest.ReadOnly =
    zio.aws.sesv2.model.PutSuppressedDestinationRequest.wrap(buildAwsValue())
}
object PutSuppressedDestinationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.PutSuppressedDestinationRequest =
      zio.aws.sesv2.model.PutSuppressedDestinationRequest(emailAddress, reason)
    def emailAddress: EmailAddress
    def reason: zio.aws.sesv2.model.SuppressionListReason
    def getEmailAddress: ZIO[Any, Nothing, EmailAddress] =
      ZIO.succeed(emailAddress)
    def getReason
        : ZIO[Any, Nothing, zio.aws.sesv2.model.SuppressionListReason] =
      ZIO.succeed(reason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationRequest
  ) extends zio.aws.sesv2.model.PutSuppressedDestinationRequest.ReadOnly {
    override val emailAddress: EmailAddress =
      zio.aws.sesv2.model.primitives.EmailAddress(impl.emailAddress())
    override val reason: zio.aws.sesv2.model.SuppressionListReason =
      zio.aws.sesv2.model.SuppressionListReason.wrap(impl.reason())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.PutSuppressedDestinationRequest
  ): zio.aws.sesv2.model.PutSuppressedDestinationRequest.ReadOnly = new Wrapper(
    impl
  )
}
