package zio.aws.sesv2.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sesv2.model.primitives.{
  Timestamp,
  RecommendationDescription,
  AmazonResourceName
}
import scala.jdk.CollectionConverters.*
final case class Recommendation(
    resourceArn: Optional[AmazonResourceName] = Optional.Absent,
    `type`: Optional[zio.aws.sesv2.model.RecommendationType] = Optional.Absent,
    description: Optional[RecommendationDescription] = Optional.Absent,
    status: Optional[zio.aws.sesv2.model.RecommendationStatus] =
      Optional.Absent,
    createdTimestamp: Optional[Timestamp] = Optional.Absent,
    lastUpdatedTimestamp: Optional[Timestamp] = Optional.Absent,
    impact: Optional[zio.aws.sesv2.model.RecommendationImpact] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sesv2.model.Recommendation = {
    import Recommendation.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sesv2.model.Recommendation
      .builder()
      .optionallyWith(
        resourceArn.map(value =>
          AmazonResourceName.unwrap(value): java.lang.String
        )
      )(_.resourceArn)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        description.map(value =>
          RecommendationDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        createdTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.createdTimestamp)
      .optionallyWith(
        lastUpdatedTimestamp.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedTimestamp)
      .optionallyWith(impact.map(value => value.unwrap))(_.impact)
      .build()
  }
  def asReadOnly: zio.aws.sesv2.model.Recommendation.ReadOnly =
    zio.aws.sesv2.model.Recommendation.wrap(buildAwsValue())
}
object Recommendation {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sesv2.model.Recommendation
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sesv2.model.Recommendation =
      zio.aws.sesv2.model.Recommendation(
        resourceArn.map(value => value),
        `type`.map(value => value),
        description.map(value => value),
        status.map(value => value),
        createdTimestamp.map(value => value),
        lastUpdatedTimestamp.map(value => value),
        impact.map(value => value)
      )
    def resourceArn: Optional[AmazonResourceName]
    def `type`: Optional[zio.aws.sesv2.model.RecommendationType]
    def description: Optional[RecommendationDescription]
    def status: Optional[zio.aws.sesv2.model.RecommendationStatus]
    def createdTimestamp: Optional[Timestamp]
    def lastUpdatedTimestamp: Optional[Timestamp]
    def impact: Optional[zio.aws.sesv2.model.RecommendationImpact]
    def getResourceArn: ZIO[Any, AwsError, AmazonResourceName] =
      AwsError.unwrapOptionField("resourceArn", resourceArn)
    def getType: ZIO[Any, AwsError, zio.aws.sesv2.model.RecommendationType] =
      AwsError.unwrapOptionField("type", `type`)
    def getDescription: ZIO[Any, AwsError, RecommendationDescription] =
      AwsError.unwrapOptionField("description", description)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.sesv2.model.RecommendationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getCreatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdTimestamp", createdTimestamp)
    def getLastUpdatedTimestamp: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedTimestamp", lastUpdatedTimestamp)
    def getImpact
        : ZIO[Any, AwsError, zio.aws.sesv2.model.RecommendationImpact] =
      AwsError.unwrapOptionField("impact", impact)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sesv2.model.Recommendation
  ) extends zio.aws.sesv2.model.Recommendation.ReadOnly {
    override val resourceArn: Optional[AmazonResourceName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.resourceArn())
        .map(value => zio.aws.sesv2.model.primitives.AmazonResourceName(value))
    override val `type`: Optional[zio.aws.sesv2.model.RecommendationType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.sesv2.model.RecommendationType.wrap(value))
    override val description: Optional[RecommendationDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.sesv2.model.primitives.RecommendationDescription(value)
        )
    override val status: Optional[zio.aws.sesv2.model.RecommendationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sesv2.model.RecommendationStatus.wrap(value))
    override val createdTimestamp: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdTimestamp())
      .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val lastUpdatedTimestamp: Optional[Timestamp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.lastUpdatedTimestamp())
        .map(value => zio.aws.sesv2.model.primitives.Timestamp(value))
    override val impact: Optional[zio.aws.sesv2.model.RecommendationImpact] =
      zio.aws.core.internal
        .optionalFromNullable(impl.impact())
        .map(value => zio.aws.sesv2.model.RecommendationImpact.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sesv2.model.Recommendation
  ): zio.aws.sesv2.model.Recommendation.ReadOnly = new Wrapper(impl)
}
