package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait RecommendationStatus {
  def unwrap: software.amazon.awssdk.services.sesv2.model.RecommendationStatus
}
object RecommendationStatus {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.RecommendationStatus
  ): zio.aws.sesv2.model.RecommendationStatus = value match {
    case software.amazon.awssdk.services.sesv2.model.RecommendationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.RecommendationStatus.OPEN =>
      val r = OPEN
      r
    case software.amazon.awssdk.services.sesv2.model.RecommendationStatus.FIXED =>
      val r = FIXED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sesv2.model.RecommendationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.RecommendationStatus =
      software.amazon.awssdk.services.sesv2.model.RecommendationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object OPEN extends zio.aws.sesv2.model.RecommendationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.RecommendationStatus =
      software.amazon.awssdk.services.sesv2.model.RecommendationStatus.OPEN
  }
  case object FIXED extends zio.aws.sesv2.model.RecommendationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.RecommendationStatus =
      software.amazon.awssdk.services.sesv2.model.RecommendationStatus.FIXED
  }
}
