package zio.aws.sesv2.model
import scala.jdk.CollectionConverters.*
sealed trait ReviewStatus {
  def unwrap: software.amazon.awssdk.services.sesv2.model.ReviewStatus
}
object ReviewStatus {
  def wrap(
      value: software.amazon.awssdk.services.sesv2.model.ReviewStatus
  ): zio.aws.sesv2.model.ReviewStatus = value match {
    case software.amazon.awssdk.services.sesv2.model.ReviewStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sesv2.model.ReviewStatus.PENDING =>
      val r = PENDING
      r
    case software.amazon.awssdk.services.sesv2.model.ReviewStatus.FAILED =>
      val r = FAILED
      r
    case software.amazon.awssdk.services.sesv2.model.ReviewStatus.GRANTED =>
      val r = GRANTED
      r
    case software.amazon.awssdk.services.sesv2.model.ReviewStatus.DENIED =>
      val r = DENIED
      r
  }
  case object unknownToSdkVersion extends zio.aws.sesv2.model.ReviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.ReviewStatus =
      software.amazon.awssdk.services.sesv2.model.ReviewStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object PENDING extends zio.aws.sesv2.model.ReviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.ReviewStatus =
      software.amazon.awssdk.services.sesv2.model.ReviewStatus.PENDING
  }
  case object FAILED extends zio.aws.sesv2.model.ReviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.ReviewStatus =
      software.amazon.awssdk.services.sesv2.model.ReviewStatus.FAILED
  }
  case object GRANTED extends zio.aws.sesv2.model.ReviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.ReviewStatus =
      software.amazon.awssdk.services.sesv2.model.ReviewStatus.GRANTED
  }
  case object DENIED extends zio.aws.sesv2.model.ReviewStatus {
    override def unwrap
        : software.amazon.awssdk.services.sesv2.model.ReviewStatus =
      software.amazon.awssdk.services.sesv2.model.ReviewStatus.DENIED
  }
}
